/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget;

import com.artipie.nuget.Hash;
import com.artipie.nuget.NuGetPackage;
import com.artipie.nuget.Nuspec;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class Nupkg
implements NuGetPackage {
    private final ByteSource content;

    public Nupkg(ByteSource content) {
        this.content = content;
    }

    @Override
    public Nuspec nuspec() throws IOException {
        Nuspec nuspec = null;
        try (ZipInputStream zipStream = new ZipInputStream(this.content.openStream());){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                if (!entry.getName().endsWith(".nuspec")) continue;
                if (nuspec != null) {
                    throw new IllegalArgumentException("More then one .nuspec file found inside the package.");
                }
                nuspec = new Nuspec(ByteSource.wrap((byte[])ByteStreams.toByteArray((InputStream)zipStream)));
            }
        }
        if (nuspec == null) {
            throw new IllegalArgumentException("No .nuspec file found inside the package.");
        }
        return nuspec;
    }

    @Override
    public Hash hash() throws IOException {
        return new Hash(Hashing.sha512().hashBytes(this.content.read()));
    }
}

