/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget;

import com.artipie.asto.blocking.BlockingStorage;
import com.artipie.nuget.PackageId;
import com.artipie.nuget.PackageIdentity;
import com.artipie.nuget.Version;
import com.google.common.io.ByteSource;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class Nuspec {
    private final ByteSource content;

    public Nuspec(ByteSource content) {
        this.content = content;
    }

    public PackageIdentity identity() throws IOException {
        return new PackageIdentity(this.packageId(), this.version());
    }

    public PackageId packageId() throws IOException {
        return new PackageId(Nuspec.single(this.xml(), "/ns:package/ns:metadata/ns:id/text()"));
    }

    public Version version() throws IOException {
        String version = Nuspec.single(this.xml(), "/ns:package/ns:metadata/ns:version/text()");
        return new Version(version);
    }

    public void save(BlockingStorage storage) throws IOException {
        storage.save(this.identity().nuspecKey(), this.content.read());
    }

    private XML xml() throws IOException {
        return new XMLDocument((InputStream)new ByteArrayInputStream(this.content.read())).registerNs("ns", (Object)"http://schemas.microsoft.com/packaging/2013/05/nuspec.xsd");
    }

    private static String single(XML xml, String xpath) {
        List values = xml.xpath(xpath);
        if (values.isEmpty()) {
            throw new IllegalArgumentException(String.format("No values found in path: '%s'", xpath));
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException(String.format("Multiple values found in path: '%s'", xpath));
        }
        return (String)values.get(0);
    }
}

