/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http.content;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.nuget.PackageIdentity;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.Route;
import com.artipie.nuget.http.metadata.ContentLocation;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class PackageContent
implements Route,
ContentLocation {
    private final URL base;
    private final Storage storage;

    public PackageContent(URL base, Storage storage) {
        this.base = base;
        this.storage = storage;
    }

    @Override
    public String path() {
        return "/content";
    }

    @Override
    public Resource resource(String path) {
        return new PackageResource(path, this.storage);
    }

    @Override
    public URL url(PackageIdentity identity) {
        String relative = String.format("%s%s/%s", this.base.getPath(), this.path(), identity.nupkgKey().string());
        try {
            return new URL(this.base, relative);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(String.format("Failed to build URL from base: '%s'", this.base), ex);
        }
    }

    private class PackageResource
    implements Resource {
        private final String path;
        private final Storage storage;

        PackageResource(String path, Storage storage) {
            this.path = path;
            this.storage = storage;
        }

        @Override
        public Response get(Headers headers) {
            return new AsyncResponse(this.existing().thenCompose(existing -> existing.map(key -> this.storage.value(key).thenApply(data -> new RsWithBody((Response)new RsWithStatus(RsStatus.OK), (Publisher)data))).orElseGet(() -> CompletableFuture.completedFuture(new RsWithStatus(RsStatus.NOT_FOUND)))));
        }

        @Override
        public Response put(Headers headers, Publisher<ByteBuffer> body) {
            return new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
        }

        private CompletableFuture<Optional<Key>> existing() {
            return CompletableFuture.supplyAsync(this::key).thenCompose(parsed -> {
                CompletionStage found;
                if (parsed.isPresent()) {
                    Key key = (Key)parsed.get();
                    found = this.storage.exists(key).thenApply(exists -> {
                        Optional<Object> existing = exists != false ? Optional.of(key) : Optional.empty();
                        return existing;
                    });
                } else {
                    found = CompletableFuture.completedFuture(Optional.empty());
                }
                return found;
            });
        }

        private Optional<Key> key() {
            String prefix = String.format("%s/", PackageContent.this.path());
            Optional<Object> parsed = this.path.startsWith(prefix) ? Optional.of(new Key.From(this.path.substring(prefix.length()))) : Optional.empty();
            return parsed;
        }
    }
}

