/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http.metadata;

import com.artipie.nuget.PackageId;
import com.artipie.nuget.Repository;
import com.artipie.nuget.http.Absent;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.Route;
import com.artipie.nuget.http.metadata.ContentLocation;
import com.artipie.nuget.http.metadata.Registration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PackageMetadata
implements Route {
    private static final String BASE = "/registrations";
    private static final Pattern REGISTRATION = Pattern.compile(String.format("%s/(?<id>[^/]+)/index.json$", "/registrations"));
    private final Repository repository;
    private final ContentLocation content;

    public PackageMetadata(Repository repository, ContentLocation content) {
        this.repository = repository;
        this.content = content;
    }

    @Override
    public String path() {
        return BASE;
    }

    @Override
    public Resource resource(String path) {
        Matcher matcher = REGISTRATION.matcher(path);
        Resource resource = matcher.find() ? new Registration(this.repository, this.content, new PackageId(matcher.group("id"))) : new Absent();
        return resource;
    }
}

