/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget;

import com.artipie.asto.Key;
import com.artipie.asto.blocking.BlockingStorage;
import com.artipie.nuget.InvalidPackageException;
import com.artipie.nuget.Nupkg;
import com.artipie.nuget.Nuspec;
import com.artipie.nuget.PackageId;
import com.artipie.nuget.PackageIdentity;
import com.artipie.nuget.PackageVersionAlreadyExistsException;
import com.artipie.nuget.Versions;
import com.google.common.io.ByteSource;
import java.io.IOException;

public final class Repository {
    private final BlockingStorage storage;

    public Repository(BlockingStorage storage) {
        this.storage = storage;
    }

    public void add(Key key) throws IOException, InterruptedException, InvalidPackageException, PackageVersionAlreadyExistsException {
        PackageIdentity id;
        Nuspec nuspec;
        Nupkg nupkg = new Nupkg(ByteSource.wrap((byte[])this.storage.value(key)));
        try {
            nuspec = nupkg.nuspec();
            id = nuspec.identity();
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new InvalidPackageException(ex);
        }
        if (!this.storage.list(id.rootKey()).isEmpty()) {
            throw new PackageVersionAlreadyExistsException(id.toString());
        }
        this.storage.move(key, id.nupkgKey());
        nupkg.hash().save(this.storage, id);
        nuspec.save(this.storage);
        Versions versions = this.versions(nuspec.packageId());
        versions.add(nuspec.version()).save(this.storage, nuspec.packageId().versionsKey());
    }

    public Versions versions(PackageId id) throws InterruptedException {
        Key key = id.versionsKey();
        Versions versions = this.storage.exists(key) ? new Versions(ByteSource.wrap((byte[])this.storage.value(key))) : new Versions();
        return versions;
    }

    public Nuspec nuspec(PackageIdentity identity) throws InterruptedException {
        if (!this.storage.exists(identity.nuspecKey())) {
            throw new IllegalArgumentException(String.format("Cannot find package: %s", identity));
        }
        return new Nuspec(ByteSource.wrap((byte[])this.storage.value(identity.nuspecKey())));
    }
}

