/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http.metadata;

import com.artipie.nuget.Nuspec;
import com.artipie.nuget.PackageId;
import com.artipie.nuget.PackageIdentity;
import com.artipie.nuget.Repository;
import com.artipie.nuget.Version;
import com.artipie.nuget.http.metadata.ContentLocation;
import java.io.IOException;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;

final class RegistrationPage {
    private final Repository repository;
    private final ContentLocation content;
    private final PackageId id;
    private final List<Version> versions;

    RegistrationPage(Repository repository, ContentLocation content, PackageId id, List<Version> versions) {
        this.repository = repository;
        this.content = content;
        this.id = id;
        this.versions = versions;
    }

    public JsonObject json() throws IOException, InterruptedException {
        if (this.versions.isEmpty()) {
            throw new IllegalStateException(String.format("Registration page contains no versions: '%s'", this.id));
        }
        Version lower = this.versions.get(0);
        Version upper = this.versions.get(this.versions.size() - 1);
        JsonArrayBuilder items = Json.createArrayBuilder();
        for (Version version : this.versions) {
            items.add((JsonValue)this.leaf(new PackageIdentity(this.id, version)));
        }
        return Json.createObjectBuilder().add("lower", lower.normalized()).add("upper", upper.normalized()).add("count", this.versions.size()).add("items", items).build();
    }

    private JsonObject leaf(PackageIdentity identity) throws IOException, InterruptedException {
        Nuspec nuspec = this.repository.nuspec(identity);
        return Json.createObjectBuilder().add("catalogEntry", Json.createObjectBuilder().add("id", nuspec.packageId().original()).add("version", nuspec.version().normalized())).add("packageContent", this.content.url(identity).toString()).build();
    }
}

