/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http.publish;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.blocking.BlockingStorage;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.nuget.InvalidPackageException;
import com.artipie.nuget.PackageVersionAlreadyExistsException;
import com.artipie.nuget.Repository;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.Route;
import com.artipie.nuget.http.publish.Multipart;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;

public final class PackagePublish
implements Route {
    private final Storage storage;

    public PackagePublish(Storage storage) {
        this.storage = storage;
    }

    @Override
    public String path() {
        return "/package";
    }

    @Override
    public Resource resource(String path) {
        return new NewPackage(this.storage);
    }

    public final class NewPackage
    implements Resource {
        private final Storage storage;

        public NewPackage(Storage storage) {
            this.storage = storage;
        }

        @Override
        public Response get(Headers headers) {
            return new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
        }

        @Override
        public Response put(Headers headers, Publisher<ByteBuffer> body) {
            return new AsyncResponse(CompletableFuture.supplyAsync(() -> new Key.From(UUID.randomUUID().toString())).thenCompose(key -> this.storage.save((Key)key, new Multipart((Iterable<Map.Entry<String, String>>)headers, body).first()).thenApply(ignored -> {
                RsStatus status;
                try {
                    new Repository(new BlockingStorage(this.storage)).add((Key)key);
                    status = RsStatus.CREATED;
                }
                catch (IOException | InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (InvalidPackageException ex) {
                    status = RsStatus.BAD_REQUEST;
                }
                catch (PackageVersionAlreadyExistsException ex) {
                    status = RsStatus.CONFLICT;
                }
                return new RsWithStatus(status);
            })));
        }
    }
}

