/*
 * MIT License
 *
 * Copyright (c) 2020 Artipie
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.artipie.nuget;

import com.artipie.asto.Content;
import com.artipie.asto.Storage;
import com.google.common.hash.HashCode;
import java.util.Base64;
import java.util.concurrent.CompletionStage;

/**
 * Package hash.
 *
 * @since 0.1
 */
public final class Hash {

    /**
     * Calculated hash code value.
     */
    private final HashCode value;

    /**
     * Ctor.
     *
     * @param value Calculated hash code value.
     */
    public Hash(final HashCode value) {
        this.value = value;
    }

    /**
     * Saves hash to storage as base64 string.
     *
     * @param storage Storage to use for saving.
     * @param identity Package identity.
     * @return Completion of save operation.
     */
    public CompletionStage<Void> save(final Storage storage, final PackageIdentity identity) {
        return storage.save(
            identity.hashKey(),
            new Content.From(Base64.getEncoder().encode(this.value.asBytes()))
        );
    }
}
