/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget;

import com.artipie.asto.Content;
import com.artipie.asto.Storage;
import com.artipie.nuget.PackageId;
import com.artipie.nuget.PackageIdentity;
import com.artipie.nuget.Version;
import com.google.common.io.ByteSource;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.CompletionStage;

public final class Nuspec {
    private final ByteSource content;

    public Nuspec(ByteSource content) {
        this.content = content;
    }

    public PackageIdentity identity() {
        return new PackageIdentity(this.packageId(), this.version());
    }

    public PackageId packageId() {
        return new PackageId(Nuspec.single(this.xml(), "/*[name()='package']/*[name()='metadata']/*[name()='id']/text()"));
    }

    public Version version() {
        String version = Nuspec.single(this.xml(), "/*[name()='package']/*[name()='metadata']/*[name()='version']/text()");
        return new Version(version);
    }

    public CompletionStage<Void> save(Storage storage) {
        try {
            return storage.save(this.identity().nuspecKey(), (Content)new Content.From(this.content.read()));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private XML xml() {
        try {
            return new XMLDocument((InputStream)new ByteArrayInputStream(this.content.read()));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static String single(XML xml, String xpath) {
        List values = xml.xpath(xpath);
        if (values.isEmpty()) {
            throw new IllegalArgumentException(String.format("No values found in path: '%s'", xpath));
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException(String.format("Multiple values found in path: '%s'", xpath));
        }
        return (String)values.get(0);
    }
}

