/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget;

import com.artipie.asto.Key;
import com.artipie.nuget.PackageId;
import com.artipie.nuget.Version;

public final class PackageIdentity {
    private final PackageId id;
    private final Version version;

    public PackageIdentity(PackageId id, Version version) {
        this.id = id;
        this.version = version;
    }

    public Key nupkgKey() {
        return new Key.From(this.rootKey(), new String[]{String.format("%s.%s.nupkg", this.id.lower(), this.version.normalized())});
    }

    public Key hashKey() {
        return new Key.From(this.rootKey(), new String[]{String.format("%s.%s.nupkg.sha512", this.id.lower(), this.version.normalized())});
    }

    public Key nuspecKey() {
        return new Key.From(this.rootKey(), new String[]{String.format("%s.nuspec", this.id.lower())});
    }

    public Key rootKey() {
        return new Key.From(this.id.rootKey(), new String[]{this.version.normalized()});
    }

    public String toString() {
        return String.format("Package: '%s' Version: '%s'", this.id, this.version);
    }
}

