/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.nuget.InvalidPackageException;
import com.artipie.nuget.Nupkg;
import com.artipie.nuget.Nuspec;
import com.artipie.nuget.PackageId;
import com.artipie.nuget.PackageIdentity;
import com.artipie.nuget.PackageVersionAlreadyExistsException;
import com.artipie.nuget.Versions;
import com.google.common.io.ByteSource;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class Repository {
    private final Storage storage;

    public Repository(Storage storage) {
        this.storage = storage;
    }

    public CompletionStage<Void> add(Key key) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.storage.value(key).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes)).thenApply(bytes -> new Nupkg(ByteSource.wrap((byte[])bytes)))).thenCompose(nupkg -> {
            PackageIdentity id;
            Nuspec nuspec;
            try {
                nuspec = nupkg.nuspec();
                id = nuspec.identity();
            }
            catch (UncheckedIOException | IllegalArgumentException ex) {
                throw new InvalidPackageException(ex);
            }
            return this.storage.list(id.rootKey()).thenCompose(existing -> {
                if (!existing.isEmpty()) {
                    throw new PackageVersionAlreadyExistsException(id.toString());
                }
                return this.storage.exclusively(nuspec.packageId().rootKey(), target -> {
                    CompletionStage<Versions> versions = this.versions(nuspec.packageId());
                    return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(target.move(key, id.nupkgKey()), nupkg.hash().save((Storage)target, id).toCompletableFuture(), nuspec.save((Storage)target).toCompletableFuture()).thenCompose(nothing -> versions)).thenApply(vers -> vers.add(nuspec.version()))).thenCompose(vers -> vers.save((Storage)target, nuspec.packageId().versionsKey()));
                });
            });
        });
    }

    public CompletionStage<Versions> versions(PackageId id) {
        Key key = id.versionsKey();
        return this.storage.exists(key).thenCompose(exists -> {
            CompletionStage<Versions> versions = exists != false ? ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.storage.value(key).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes)).thenApply(ByteSource::wrap)).thenApply(Versions::new) : CompletableFuture.completedFuture(new Versions());
            return versions;
        });
    }

    public CompletionStage<Nuspec> nuspec(PackageIdentity identity) {
        return this.storage.exists(identity.nuspecKey()).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                throw new IllegalArgumentException(String.format("Cannot find package: %s", identity));
            }
            return ((CompletableFuture)((CompletableFuture)this.storage.value(identity.nuspecKey()).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes)).thenApply(bytes -> new Nuspec(ByteSource.wrap((byte[])bytes)));
        });
    }
}

