/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http;

import com.artipie.asto.Storage;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.auth.Action;
import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.BasicIdentities;
import com.artipie.http.auth.Identities;
import com.artipie.http.auth.Permission;
import com.artipie.http.auth.Permissions;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.nuget.Repository;
import com.artipie.nuget.http.BasicAuthRoute;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.Route;
import com.artipie.nuget.http.RouteService;
import com.artipie.nuget.http.RoutingResource;
import com.artipie.nuget.http.content.PackageContent;
import com.artipie.nuget.http.index.ServiceIndex;
import com.artipie.nuget.http.metadata.PackageMetadata;
import com.artipie.nuget.http.publish.PackagePublish;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class NuGet
implements Slice {
    private final URL url;
    private final Storage storage;
    private final Permissions perms;
    private final Identities users;

    public NuGet(URL url, Storage storage) {
        this(url, storage, Permissions.FREE, Identities.ANONYMOUS);
    }

    public NuGet(URL url, Storage storage, Permissions perms, Authentication auth) {
        this(url, storage, perms, (Identities)new BasicIdentities(auth));
    }

    private NuGet(URL url, Storage storage, Permissions perms, Identities users) {
        this.url = url;
        this.storage = storage;
        this.perms = perms;
        this.users = users;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RequestLineFrom request = new RequestLineFrom(line);
        String path = request.uri().getPath();
        Resource resource = this.resource(path);
        RqMethod method = request.method();
        Object response = method.equals((Object)RqMethod.GET) ? resource.get((Headers)new Headers.From(headers)) : (method.equals((Object)RqMethod.PUT) ? resource.put((Headers)new Headers.From(headers), body) : new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED));
        return response;
    }

    private Resource resource(String path) {
        PackagePublish publish = new PackagePublish(this.storage);
        PackageContent content = new PackageContent(this.url, this.storage);
        PackageMetadata metadata = new PackageMetadata(new Repository(this.storage), content);
        return new RoutingResource(path, new ServiceIndex(Arrays.asList(new RouteService(this.url, publish, "PackagePublish/2.0.0"), new RouteService(this.url, metadata, "RegistrationsBaseUrl/Versioned"), new RouteService(this.url, content, "PackageBaseAddress/3.0.0"))), this.auth(publish, (Action)Action.Standard.WRITE), this.auth(content, (Action)Action.Standard.READ), this.auth(metadata, (Action)Action.Standard.READ));
    }

    private Route auth(Route route, Action action) {
        return new BasicAuthRoute(route, (Permission)new Permission.ByName(this.perms, action), this.users);
    }
}

