/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.streams.ContentAsStream;
import com.artipie.nuget.Hash;
import com.artipie.nuget.Nupkg;
import com.artipie.nuget.PackageIdentity;
import com.artipie.nuget.PackageKeys;
import com.artipie.nuget.PackageVersionAlreadyExistsException;
import com.artipie.nuget.Repository;
import com.artipie.nuget.Versions;
import com.artipie.nuget.metadata.Nuspec;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.json.Json;
import org.reactivestreams.Publisher;

public final class AstoRepository
implements Repository {
    private final Storage storage;

    public AstoRepository(Storage storage) {
        this.storage = storage;
    }

    @Override
    public CompletionStage<Optional<Content>> content(Key key) {
        return this.storage.exists(key).thenCompose(exists -> {
            CompletionStage result = exists != false ? this.storage.value(key).thenApply(Optional::of) : CompletableFuture.completedFuture(Optional.empty());
            return result;
        });
    }

    @Override
    public CompletionStage<Void> add(Content content) {
        Key.From key = new Key.From(UUID.randomUUID().toString());
        return this.storage.save((Key)key, content).thenCompose(arg_0 -> this.lambda$add$11((Key)key, arg_0));
    }

    @Override
    public CompletionStage<Versions> versions(PackageKeys id) {
        Key key = id.versionsKey();
        return this.storage.exists(key).thenCompose(exists -> {
            CompletionStage<Versions> versions = exists != false ? this.storage.value(key).thenCompose(val -> new ContentAsStream((Publisher)val).process(input -> new Versions(Json.createReader((InputStream)input).readObject()))) : CompletableFuture.completedFuture(new Versions());
            return versions;
        });
    }

    @Override
    public CompletionStage<Nuspec> nuspec(PackageIdentity identity) {
        return this.storage.exists(identity.nuspecKey()).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                throw new IllegalArgumentException(String.format("Cannot find package: %s", identity));
            }
            return this.storage.value(identity.nuspecKey()).thenCompose(val -> new ContentAsStream((Publisher)val).process(Nuspec.Xml::new));
        });
    }

    private /* synthetic */ CompletionStage lambda$add$11(Key key, Void saved) {
        return ((CompletableFuture)this.storage.value(key).thenCompose(val -> new ContentAsStream((Publisher)val).process(input -> new Nupkg((InputStream)input).nuspec()))).thenCompose(nuspec -> {
            PackageIdentity id = new PackageIdentity(nuspec.id(), nuspec.version());
            return this.storage.list(id.rootKey()).thenCompose(existing -> {
                if (!existing.isEmpty()) {
                    throw new PackageVersionAlreadyExistsException(id.toString());
                }
                PackageKeys pkey = new PackageKeys(nuspec.id());
                return this.storage.exclusively(pkey.rootKey(), target -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{this.storage.value(key).thenCompose(val -> new Hash((Publisher<ByteBuffer>)val).save((Storage)target, id)), this.storage.save(new PackageIdentity(nuspec.id(), nuspec.version()).nuspecKey(), (Content)new Content.From(nuspec.bytes()))}).thenCompose(nothing -> target.move(key, id.nupkgKey()))).thenCompose(nothing -> this.versions(pkey))).thenApply(vers -> vers.add(nuspec.version()))).thenCompose(vers -> vers.save((Storage)target, pkey.versionsKey())));
            });
        });
    }
}

