/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget;

import com.artipie.nuget.InvalidPackageException;
import com.artipie.nuget.NuGetPackage;
import com.artipie.nuget.metadata.Nuspec;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;

public final class Nupkg
implements NuGetPackage {
    private final InputStream content;

    public Nupkg(InputStream content) {
        this.content = content;
    }

    @Override
    public Nuspec nuspec() {
        Optional<Object> res = Optional.empty();
        try (ArchiveInputStream archive = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(this.content));){
            ArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (!archive.canReadEntryData(entry) || entry.isDirectory() || !entry.getName().endsWith(".nuspec")) continue;
                res = Optional.of(new Nuspec.Xml((InputStream)archive));
            }
        }
        catch (IOException | ArchiveException ex) {
            throw new InvalidPackageException(ex);
        }
        return (Nuspec)res.orElseThrow(() -> new InvalidPackageException(new IllegalArgumentException("No .nuspec file found inside the package.")));
    }
}

