/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http;

import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.nuget.http.Absent;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.Route;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import org.reactivestreams.Publisher;

public final class RoutingResource
implements Resource {
    private final String path;
    private final Route[] routes;

    public RoutingResource(String path, Route ... routes) {
        this.path = path;
        this.routes = Arrays.copyOf(routes, routes.length);
    }

    @Override
    public Response get(Headers headers) {
        return this.resource().get(headers);
    }

    @Override
    public Response put(Headers headers, Publisher<ByteBuffer> body) {
        return this.resource().put(headers, body);
    }

    private Resource resource() {
        return Arrays.stream(this.routes).filter(r -> this.path.startsWith(r.path())).max(Comparator.comparing(Route::path)).map(r -> r.resource(this.path)).orElse(new Absent());
    }
}

