/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http.content;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.nuget.PackageIdentity;
import com.artipie.nuget.Repository;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.Route;
import com.artipie.nuget.http.RsWithBodyNoHeaders;
import com.artipie.nuget.http.metadata.ContentLocation;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.reactivestreams.Publisher;

public final class PackageContent
implements Route,
ContentLocation {
    private final URL base;
    private final Repository repository;

    public PackageContent(URL base, Repository repository) {
        this.base = base;
        this.repository = repository;
    }

    @Override
    public String path() {
        return "/content";
    }

    @Override
    public Resource resource(String path) {
        return new PackageResource(path, this.repository);
    }

    @Override
    public URL url(PackageIdentity identity) {
        String relative = String.format("%s%s/%s", this.base.getPath(), this.path(), identity.nupkgKey().string());
        try {
            return new URL(this.base, relative);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(String.format("Failed to build URL from base: '%s'", this.base), ex);
        }
    }

    private class PackageResource
    implements Resource {
        private final String path;
        private final Repository repository;

        PackageResource(String path, Repository repository) {
            this.path = path;
            this.repository = repository;
        }

        @Override
        public Response get(Headers headers) {
            return this.key().map(key -> new AsyncResponse(this.repository.content((Key)key).thenApply(existing -> existing.map(data -> new RsWithBodyNoHeaders((Response)new RsWithStatus(RsStatus.OK), (Content)data)).orElse((Response)new RsWithStatus(RsStatus.NOT_FOUND))))).orElse((Response)new RsWithStatus(RsStatus.NOT_FOUND));
        }

        @Override
        public Response put(Headers headers, Publisher<ByteBuffer> body) {
            return new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
        }

        private Optional<Key> key() {
            String prefix = String.format("%s/", PackageContent.this.path());
            Optional<Object> parsed = this.path.startsWith(prefix) ? Optional.of(new Key.From(this.path.substring(prefix.length()))) : Optional.empty();
            return parsed;
        }
    }
}

