/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.http.publish;

import com.artipie.asto.Content;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.nuget.InvalidPackageException;
import com.artipie.nuget.PackageVersionAlreadyExistsException;
import com.artipie.nuget.Repository;
import com.artipie.nuget.http.Resource;
import com.artipie.nuget.http.Route;
import com.artipie.nuget.http.publish.Multipart;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;

public final class PackagePublish
implements Route {
    private final Repository repository;

    public PackagePublish(Repository repository) {
        this.repository = repository;
    }

    @Override
    public String path() {
        return "/package";
    }

    @Override
    public Resource resource(String path) {
        return new NewPackage(this.repository);
    }

    public static final class NewPackage
    implements Resource {
        private final Repository repository;

        public NewPackage(Repository repository) {
            this.repository = repository;
        }

        @Override
        public Response get(Headers headers) {
            return new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
        }

        @Override
        public Response put(Headers headers, Publisher<ByteBuffer> body) {
            return new AsyncResponse(CompletableFuture.supplyAsync(() -> new Multipart((Iterable<Map.Entry<String, String>>)headers, body).first()).thenCompose(content -> this.repository.add((Content)content).thenApply(nothing -> RsStatus.CREATED).exceptionally(throwable -> NewPackage.toStatus(throwable.getCause())).thenApply(RsWithStatus::new)));
        }

        private static RsStatus toStatus(Throwable throwable) {
            RsStatus status = throwable instanceof InvalidPackageException ? RsStatus.BAD_REQUEST : (throwable instanceof PackageVersionAlreadyExistsException ? RsStatus.CONFLICT : RsStatus.INTERNAL_ERROR);
            return status;
        }
    }
}

