/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.commons.lang3.tuple.ImmutablePair;

public interface DependencyGroups {
    public JsonArray build();

    public static class FromVersions
    implements DependencyGroups {
        private static final int MAX_SIZE = 3;
        private final Collection<String> versions;

        public FromVersions(Collection<String> versions) {
            this.versions = versions;
        }

        @Override
        public JsonArray build() {
            HashMap<String, List> items = new HashMap<String, List>(this.versions.size());
            for (String item : this.versions) {
                String framework = FromVersions.getFramework(item);
                items.compute(framework, (key, val) -> {
                    ArrayList<ImmutablePair> res = val;
                    if (res == null) {
                        res = new ArrayList<ImmutablePair>(this.versions.size());
                    }
                    res.add(new ImmutablePair((Object)FromVersions.getId(item), (Object)FromVersions.getVersion(item)));
                    return res;
                });
            }
            JsonArrayBuilder array = Json.createArrayBuilder();
            for (Map.Entry entry : items.entrySet()) {
                JsonObjectBuilder builder = Json.createObjectBuilder();
                JsonArrayBuilder arr = Json.createArrayBuilder();
                ((List)entry.getValue()).forEach(pair -> arr.add((JsonValue)Json.createObjectBuilder().add("id", (String)pair.getKey()).add("range", (String)pair.getValue()).build()));
                builder.add("dependencies", arr);
                builder.add("targetFramework", (String)entry.getKey());
                array.add(builder);
            }
            return array.build();
        }

        public String toString() {
            return this.build().toString();
        }

        private static String getVersion(String item) {
            String[] arr = item.split(":");
            String version = arr.length == 3 || arr.length == 2 && item.endsWith(":") ? arr[1] : (item.charAt(0) == ':' ? arr[0] : "");
            return version;
        }

        private static String getId(String item) {
            String[] arr = item.split(":");
            String id = arr.length == 3 || arr.length == 2 && item.endsWith(":") ? arr[0] : "";
            return id;
        }

        private static String getFramework(String item) {
            String[] arr = item.split(":");
            String framework = arr.length == 3 ? arr[2] : (item.endsWith(":") ? "" : arr[1]);
            return framework;
        }
    }
}

