/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.metadata;

import com.artipie.ArtipieException;
import com.artipie.asto.ArtipieIOException;
import com.artipie.nuget.metadata.NuspecField;
import com.artipie.nuget.metadata.OptFieldName;
import com.artipie.nuget.metadata.PackageId;
import com.artipie.nuget.metadata.Version;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public interface Nuspec {
    public NuspecField id();

    public NuspecField version();

    public String description();

    public String authors();

    public Optional<String> fieldByName(OptFieldName var1);

    public Collection<String> dependencies();

    public Set<String> packageTypes();

    public byte[] bytes();

    public static final class Xml
    implements Nuspec {
        private static final String VRSN = "version";
        private final XMLDocument content;
        private final byte[] bytes;

        public Xml(byte[] bytes) {
            this.bytes = bytes;
            this.content = new XMLDocument(bytes);
        }

        public Xml(InputStream input) {
            this(Xml.read(input));
        }

        @Override
        public NuspecField id() {
            return new PackageId(Xml.single((XML)this.content, "/*[name()='package']/*[name()='metadata']/*[name()='id']/text()"));
        }

        @Override
        public NuspecField version() {
            String version = Xml.single((XML)this.content, "/*[name()='package']/*[name()='metadata']/*[name()='version']/text()");
            return new Version(version);
        }

        @Override
        public String description() {
            return Xml.single((XML)this.content, "/*[name()='package']/*[name()='metadata']/*[name()='description']/text()");
        }

        @Override
        public String authors() {
            return Xml.single((XML)this.content, "/*[name()='package']/*[name()='metadata']/*[name()='authors']/text()");
        }

        @Override
        public Optional<String> fieldByName(OptFieldName name) {
            List values = this.content.xpath(String.format("/*[name()='package']/*[name()='metadata']/*[name()='%s']/text()", name.get()));
            Optional<String> res = Optional.empty();
            if (!values.isEmpty()) {
                res = Optional.of(values.get(0));
            }
            return res;
        }

        @Override
        public Collection<String> dependencies() {
            List deps = this.content.nodes("/*[name()='package']/*[name()='metadata']/*[name()='dependencies']");
            ArrayList<String> res = new ArrayList<String>(10);
            if (!deps.isEmpty()) {
                List groups = this.content.nodes("/*[name()='package']/*[name()='metadata']/*[name()='dependencies']/*[name()='group']");
                for (XML group : groups) {
                    String tfv = Optional.ofNullable(group.node().getAttributes().getNamedItem("targetFramework")).map(Node::getNodeValue).orElse("");
                    NodeList list = group.node().getChildNodes();
                    boolean empty = true;
                    for (int cnt = 0; cnt < list.getLength(); ++cnt) {
                        Node item = list.item(cnt);
                        if (!"dependency".equals(item.getLocalName())) continue;
                        empty = false;
                        String id = Optional.ofNullable(item.getAttributes().getNamedItem("id")).map(Node::getNodeValue).orElse("");
                        String version = Optional.ofNullable(item.getAttributes().getNamedItem(VRSN)).map(Node::getNodeValue).orElse("");
                        res.add(String.format("%s:%s:%s", id, version, tfv));
                    }
                    if (!empty) continue;
                    res.add(String.format("::%s", tfv));
                }
            }
            return res;
        }

        @Override
        public Set<String> packageTypes() {
            List root = this.content.nodes("/*[name()='package']/*[name()='metadata']/*[name()='packageTypes']");
            HashSet<String> res = new HashSet<String>(1);
            if (!root.isEmpty()) {
                List types = this.content.nodes("/*[name()='package']/*[name()='metadata']/*[name()='packageTypes']/*[name()='packageType']");
                for (XML type : types) {
                    res.add(String.format("%s:%s", type.node().getAttributes().getNamedItem("name").getNodeValue(), Optional.ofNullable(type.node().getAttributes().getNamedItem(VRSN)).map(Node::getNodeValue).orElse("")));
                }
            }
            return res;
        }

        @Override
        public byte[] bytes() {
            return this.bytes;
        }

        public String toString() {
            return new String(this.bytes(), StandardCharsets.UTF_8);
        }

        private static String single(XML xml, String xpath) {
            List values = xml.xpath(xpath);
            if (values.isEmpty()) {
                throw new ArtipieException((Throwable)new IllegalArgumentException(String.format("No values found in path: '%s'", xpath)));
            }
            if (values.size() > 1) {
                throw new ArtipieException((Throwable)new IllegalArgumentException(String.format("Multiple values found in path: '%s'", xpath)));
            }
            return (String)values.get(0);
        }

        private static byte[] read(InputStream input) {
            try {
                return IOUtils.toByteArray((InputStream)input);
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }
    }
}

