/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.metadata;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;

public final class SearchResults {
    private final OutputStream out;

    public SearchResults(OutputStream out) {
        this.out = out;
    }

    void generate(Collection<Package> packages) throws IOException {
        JsonGenerator gen = new JsonFactory().createGenerator(this.out);
        gen.writeStartObject();
        gen.writeNumberField("totalHits", packages.size());
        gen.writeFieldName("data");
        gen.writeStartArray();
        for (Package item : packages) {
            gen.writeStartObject();
            gen.writeStringField("id", item.id);
            gen.writeStringField("version", item.version());
            gen.writeFieldName("packageTypes");
            gen.writeArray(item.types.toArray(new String[0]), 0, item.types.size());
            gen.writeFieldName("versions");
            gen.writeStartArray();
            for (Version vers : item.versions) {
                vers.write(gen);
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.close();
    }

    public static final class Version {
        private final String value;
        private final long downloads;
        private final String id;

        Version(String value, long downloads, String id) {
            this.value = value;
            this.downloads = downloads;
            this.id = id;
        }

        private void write(JsonGenerator gen) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("version", new com.artipie.nuget.metadata.Version(this.value).normalized());
            gen.writeNumberField("downloads", this.downloads);
            gen.writeStringField("@id", this.id);
            gen.writeEndObject();
        }
    }

    public static final class Package {
        private final String id;
        private final Collection<String> types;
        private final Collection<Version> versions;

        public Package(String id, Collection<String> types, Collection<Version> versions) {
            this.id = id;
            this.types = types;
            this.versions = versions;
        }

        String version() {
            return this.versions.stream().map(vers -> new com.artipie.nuget.metadata.Version(((Version)vers).value)).max(com.artipie.nuget.metadata.Version::compareTo).get().normalized();
        }
    }
}

