/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.metadata;

import com.artipie.nuget.metadata.NuspecField;
import com.artipie.nuget.metadata.VersionLabel;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version>,
NuspecField {
    private static final Pattern PATTERN = Pattern.compile(String.join((CharSequence)"", "(?<major>\\d+)\\.(?<minor>\\d+)", "(\\.(?<patch>\\d+)(\\.(?<revision>\\d+))?)?", "(-(?<label>[0-9a-zA-Z\\-]+(\\.[0-9a-zA-Z\\-]+)*))?", "(\\+(?<metadata>[0-9a-zA-Z\\-]+(\\.[0-9a-zA-Z\\-]+)*))?", "$"));
    private final String val;

    public Version(String raw) {
        this.val = raw;
    }

    @Override
    public String raw() {
        return this.val;
    }

    @Override
    public String normalized() {
        StringBuilder builder = new StringBuilder().append(Version.removeLeadingZeroes(this.major())).append('.').append(Version.removeLeadingZeroes(this.minor()));
        this.patch().ifPresent(patch -> builder.append('.').append(Version.removeLeadingZeroes(patch)));
        this.revision().ifPresent(revision -> {
            String rev = Version.removeLeadingZeroes(revision);
            if (!rev.equals("0")) {
                builder.append('.').append(rev);
            }
        });
        this.label().ifPresent(label -> builder.append('-').append((String)label));
        return builder.toString();
    }

    @Override
    public int compareTo(Version that) {
        return Comparator.comparingInt(version -> Integer.parseInt(version.major())).thenComparingInt(version -> Integer.parseInt(version.minor())).thenComparingInt(version -> version.patch().map(Integer::parseInt).orElse(0)).thenComparingInt(version -> version.revision().map(Integer::parseInt).orElse(0)).thenComparing(Version::compareLabelTo).compare(this, that);
    }

    public String toString() {
        return this.val;
    }

    public boolean isSemVerTwo() {
        return this.metadata().isPresent() || this.label().map(lbl -> lbl.contains(".")).orElse(false) != false;
    }

    public boolean isPrerelease() {
        return this.label().isPresent();
    }

    private String major() {
        return this.group("major").orElseThrow(() -> new IllegalStateException("Major identifier is missing"));
    }

    private String minor() {
        return this.group("minor").orElseThrow(() -> new IllegalStateException("Minor identifier is missing"));
    }

    private Optional<String> patch() {
        return this.group("patch");
    }

    private Optional<String> revision() {
        return this.group("revision");
    }

    private Optional<String> label() {
        return this.group("label");
    }

    private Optional<String> metadata() {
        return this.group("metadata");
    }

    private Optional<String> group(String name) {
        return Optional.ofNullable(this.matcher().group(name));
    }

    private Matcher matcher() {
        Matcher matcher = PATTERN.matcher(this.val);
        if (!matcher.find()) {
            throw new IllegalStateException(String.format("Unexpected version format: %s", this.val));
        }
        return matcher;
    }

    private int compareLabelTo(Version that) {
        Optional<String> one = this.label();
        Optional<String> two = that.label();
        int result = one.isPresent() ? (two.isPresent() ? Comparator.comparing(VersionLabel::new).compare(one.get(), two.get()) : -1) : (two.isPresent() ? 1 : 0);
        return result;
    }

    private static String removeLeadingZeroes(String string) {
        return string.replaceFirst("^0+(?!$)", "");
    }
}

