/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.metadata;

import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class VersionLabel
implements Comparable<VersionLabel> {
    private final String label;

    VersionLabel(String label) {
        this.label = label;
    }

    @Override
    public int compareTo(VersionLabel that) {
        List<Identifier> one = this.identifiers();
        List<Identifier> two = that.identifiers();
        int compare = 0;
        for (int index = 0; index < one.size(); ++index) {
            if (index >= two.size()) {
                compare = 1;
                break;
            }
            int result = one.get(index).compareTo(two.get(index));
            if (result == 0) continue;
            compare = result;
            break;
        }
        if (compare == 0 && one.size() < two.size()) {
            compare = -1;
        }
        return compare;
    }

    private List<Identifier> identifiers() {
        return Stream.of(this.label.split("\\.")).map(Identifier::new).collect(Collectors.toList());
    }

    private static class Identifier
    implements Comparable<Identifier> {
        private final String value;

        Identifier(String value) {
            this.value = value;
        }

        @Override
        public int compareTo(Identifier that) {
            OptionalInt one = this.number();
            OptionalInt two = that.number();
            int compare = one.isPresent() ? (two.isPresent() ? Integer.compare(one.getAsInt(), two.getAsInt()) : -1) : (two.isPresent() ? 1 : this.value.compareTo(that.value));
            return compare;
        }

        private OptionalInt number() {
            OptionalInt res = this.value.matches("\\d+") ? OptionalInt.of(Integer.parseInt(this.value)) : OptionalInt.empty();
            return res;
        }
    }
}

