/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.pypi.ByteFlow;
import com.artipie.pypi.Flow;
import com.artipie.pypi.LiveMeta;
import com.artipie.pypi.Meta;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public final class PackagesMeta
implements LiveMeta {
    private final Flow<ByteBuffer> content;

    public PackagesMeta() {
        this("<html><body><table><thead><tr><th>Filename</th></tr></thead><tbody></tbody></table></body></html>");
    }

    public PackagesMeta(String content) {
        this.content = new ByteFlow(content);
    }

    @Override
    public Meta update(Meta meta) {
        Document doc = Jsoup.parse((String)this.content.toString());
        Element tbody = (Element)doc.getElementsByTag("tbody").get(0);
        ArrayList trs = new ArrayList(tbody.getElementsByTag("tr"));
        boolean found = trs.stream().anyMatch(tr -> meta.html().equals(PackagesMeta.normalizedHtmlString(tr.outerHtml())));
        if (!found) {
            tbody.append(meta.html());
        }
        return new PackagesMeta(PackagesMeta.normalizedHtmlString(doc.html()));
    }

    @Override
    public CompletableFuture<Void> save(Storage storage, Key key) {
        return storage.save(key, this.content.value());
    }

    @Override
    public String html() {
        return this.content.toString();
    }

    private static String normalizedHtmlString(String html) {
        return html.replaceAll(">\\s+", ">").trim();
    }
}

