/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi;

import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.pypi.StaticContent;
import java.nio.ByteBuffer;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class PySlice
implements Slice {
    private final String base;
    private final Storage storage;

    public PySlice(String base, Storage storage) {
        this.base = base;
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Object response;
        RequestLineFrom request = new RequestLineFrom(line);
        String path = request.uri().getPath();
        if (path.startsWith(this.base)) {
            StaticContent resource = new StaticContent(path.substring(this.base.length()), this.storage);
            RqMethod method = request.method();
            response = method.equals((Object)RqMethod.GET) ? resource.get() : new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
        } else {
            response = new RsWithStatus(RsStatus.NOT_FOUND);
        }
        return response;
    }
}

