/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi.http;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Remaining;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.ParameterParser;
import org.reactivestreams.Publisher;

final class Multipart {
    private static final int BUFFER = 4096;
    private final Iterable<Map.Entry<String, String>> headers;
    private final Publisher<ByteBuffer> body;

    Multipart(Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        this.headers = headers;
        this.body = body;
    }

    public Content content() {
        return new Content.From((Publisher)new Concatenation(this.body).single().map(Remaining::new).map(Remaining::bytes).map(ByteArrayInputStream::new).map(input -> new MultipartStream((InputStream)input, this.boundary(), 4096, null)).map(Multipart::content).toFlowable());
    }

    private byte[] boundary() {
        String header = StreamSupport.stream(this.headers.spliterator(), false).filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("Content-Type")).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find header \"Content-Type\""));
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        String boundary = (String)Objects.requireNonNull(parser.parse(header, ';').get("boundary"), String.format("Boundary not specified: '%s'", header));
        return boundary.getBytes(StandardCharsets.ISO_8859_1);
    }

    private static ByteBuffer content(MultipartStream stream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            boolean next = stream.skipPreamble();
            while (next) {
                String header = stream.readHeaders();
                if (header.contains("filename")) {
                    stream.readBodyData((OutputStream)bos);
                    return ByteBuffer.wrap(bos.toByteArray());
                }
                stream.discardBodyData();
                next = stream.readBoundary();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read body as multipart", ex);
        }
        throw new IllegalStateException("Body has no file data");
    }
}

