/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.pypi.http.Multipart;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class WheelSlice
implements Slice {
    private static final Pattern PKG_NAME = Pattern.compile("(.*?)-.*");
    private final Storage storage;

    WheelSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> iterable, Publisher<ByteBuffer> publisher) {
        return new AsyncResponse(new Multipart(iterable, publisher).content().thenApply(data -> this.storage.save(WheelSlice.key(data.fileName()), (Content)new Content.From(data.bytes()))).thenApply(ignored -> new RsWithStatus(RsStatus.CREATED)));
    }

    private static Key key(String filename) {
        Matcher matcher = PKG_NAME.matcher(filename);
        if (matcher.matches()) {
            return new Key.From(new String[]{matcher.group(1), filename});
        }
        throw new IllegalArgumentException("Invalid file");
    }
}

