/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi.meta;

import java.util.stream.Stream;

public interface PackageInfo {
    public String name();

    public String version();

    public static final class FromMetadata
    implements PackageInfo {
        private final String input;

        public FromMetadata(String input) {
            this.input = input;
        }

        @Override
        public String name() {
            return this.read("Name");
        }

        @Override
        public String version() {
            return this.read("Version");
        }

        private String read(String header) {
            String name = String.format("%s:", header);
            return Stream.of(this.input.split("\n")).filter(line -> line.startsWith(name)).findFirst().map(line -> line.replace(name, "").trim()).orElseThrow(() -> new IllegalArgumentException(String.format("Invalid metadata file, header %s not found", header)));
        }
    }
}

