/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi.http;

import com.artipie.asto.ext.PublisherAs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.ParameterParser;
import org.reactivestreams.Publisher;

final class Multipart {
    private static final int BUFFER = 4096;
    private static final Pattern FILENAME = Pattern.compile(".*filename=\"(.*)\"(.*\\s*)*");
    private final Iterable<Map.Entry<String, String>> headers;
    private final Publisher<ByteBuffer> body;

    Multipart(Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        this.headers = headers;
        this.body = body;
    }

    public CompletionStage<Data> content() {
        return new PublisherAs(this.body).bytes().thenApply(ByteArrayInputStream::new).thenApply(input -> new MultipartStream((InputStream)input, this.boundary(), 4096, null)).thenApply(Multipart::content);
    }

    private byte[] boundary() {
        String header = StreamSupport.stream(this.headers.spliterator(), false).filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("Content-Type")).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find header \"Content-Type\""));
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        String boundary = (String)Objects.requireNonNull(parser.parse(header, ';').get("boundary"), String.format("Boundary not specified: '%s'", header));
        return boundary.getBytes(StandardCharsets.ISO_8859_1);
    }

    private static Data content(MultipartStream stream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            boolean next = stream.skipPreamble();
            while (next) {
                String header = stream.readHeaders();
                if (header.contains("filename")) {
                    Matcher matcher = FILENAME.matcher(header);
                    stream.readBodyData((OutputStream)bos);
                    matcher.matches();
                    return new Data(matcher.group(1), bos.toByteArray());
                }
                stream.discardBodyData();
                next = stream.readBoundary();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read body as multipart", ex);
        }
        throw new IllegalStateException("Body has no file data");
    }

    static final class Data {
        private final String fname;
        private final byte[] buffer;

        Data(String filename, byte[] buffer) {
            this.fname = filename;
            this.buffer = buffer;
        }

        public String fileName() {
            return this.fname;
        }

        public byte[] bytes() {
            return this.buffer;
        }
    }
}

