/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.cache.Cache;
import com.artipie.asto.cache.CacheControl;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.Header;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.slice.KeyFromPath;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;

final class ProxySlice
implements Slice {
    private final Slice origin;
    private final Cache cache;

    ProxySlice(Slice origin, Cache cache) {
        this.origin = origin;
        this.cache = cache;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> ignored, Publisher<ByteBuffer> pub) {
        AtomicReference headers = new AtomicReference();
        AtomicReference status = new AtomicReference();
        return new AsyncResponse(this.cache.load((Key)new KeyFromPath(new RequestLineFrom(line).uri().getPath()), () -> {
            CompletableFuture promise = new CompletableFuture();
            this.origin.response(line, (Iterable)Headers.EMPTY, (Publisher)Content.EMPTY).send((rsstatus, rsheaders, rsbody) -> {
                CompletableFuture term = new CompletableFuture();
                headers.set(rsheaders);
                status.set(rsstatus);
                if (rsstatus.success()) {
                    Flowable body = Flowable.fromPublisher((Publisher)rsbody).doOnError(term::completeExceptionally).doOnTerminate(() -> term.complete(null));
                    promise.complete(new Content.From((Publisher)body));
                } else {
                    promise.completeExceptionally(new IllegalStateException(String.format("Unsuccessful response code %s received", rsstatus.code())));
                }
                return term;
            });
            return promise;
        }, (CacheControl)CacheControl.Standard.ALWAYS).handle((content, throwable) -> {
            CompletableFuture<Object> result = new CompletableFuture<Object>();
            if (throwable == null) {
                result.complete(new RsFull(RsStatus.OK, (Iterable)new Headers.From((Map.Entry)ProxySlice.contentType((Headers)headers.get(), line)), (Publisher)content));
            } else {
                result.complete(new RsWithHeaders((Response)new RsWithStatus((RsStatus)status.get()), (Headers)headers.get()));
            }
            return result;
        }).thenCompose(Function.identity()));
    }

    private static Header contentType(Headers headers, String line) {
        String name = "content-type";
        return StreamSupport.stream(headers.spliterator(), false).filter(header -> ((String)header.getKey()).equalsIgnoreCase("content-type")).findFirst().map(Header::new).orElseGet(() -> {
            Header res = new Header("content-type", "text/html");
            if (new RequestLineFrom(line).uri().toString().matches(".*\\.(whl|tar\\.gz|zip|tar\\.bz2|tar\\.Z|tar|egg)")) {
                res = new Header("content-type", "multipart/form-data");
            }
            return res;
        });
    }
}

