/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi;

import java.util.Locale;
import java.util.regex.Pattern;

public interface NormalizedProjectName {
    public String value();

    public static final class Simple
    implements NormalizedProjectName {
        private static final Pattern VERIFY = Pattern.compile("[A-Za-z0-9.\\-_]+");
        private final String name;

        public Simple(String name) {
            this.name = name;
        }

        @Override
        public String value() {
            if (VERIFY.matcher(this.name).matches()) {
                return this.name.replaceAll("[-_.]+", "-").toLowerCase(Locale.US);
            }
            throw new IllegalArgumentException("Invalid name: python project should match [A-Za-z0-9.-_]+");
        }
    }
}

