/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi.meta;

import com.artipie.pypi.meta.PackageInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.io.IOUtils;

public interface Metadata {
    public PackageInfo read();

    public static final class FromArchive
    implements Metadata {
        private final Path file;
        private final String filename;

        public FromArchive(Path file, String filename) {
            this.file = file;
            this.filename = filename;
        }

        public FromArchive(Path file) {
            this(file, file.getFileName().toString());
        }

        @Override
        public PackageInfo read() {
            PackageInfo res;
            if (Stream.of("tar", "zip", "whl", "egg").anyMatch(this.filename::endsWith)) {
                res = this.readZipTarOrWhl();
            } else if (this.filename.endsWith("tar.gz")) {
                res = this.readTarGz();
            } else if (this.filename.endsWith("tar.Z")) {
                res = this.readTarZ();
            } else if (this.filename.endsWith("tar.bz2")) {
                res = this.readBz();
            } else {
                throw new UnsupportedOperationException("Unsupported archive type");
            }
            return res;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private PackageInfo readTarZ() {
            try (ZCompressorInputStream origin = new ZCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0])));){
                PackageInfo packageInfo = FromArchive.unpack((InputStream)origin);
                return packageInfo;
            }
            catch (IOException | ArchiveException ex) {
                throw FromArchive.error((Exception)ex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private PackageInfo readBz() {
            try (BZip2CompressorInputStream origin = new BZip2CompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0])));){
                PackageInfo packageInfo = FromArchive.unpack((InputStream)origin);
                return packageInfo;
            }
            catch (IOException | ArchiveException ex) {
                throw FromArchive.error((Exception)ex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private PackageInfo readZipTarOrWhl() {
            try (ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0])));){
                PackageInfo packageInfo = FromArchive.readArchive(input);
                return packageInfo;
            }
            catch (IOException | ArchiveException ex) {
                throw FromArchive.error((Exception)ex);
            }
        }

        /*
         * Exception decompiling
         */
        private PackageInfo readTarGz() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static PackageInfo unpack(InputStream origin) throws IOException, ArchiveException {
            try (ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)origin))));){
                PackageInfo packageInfo = FromArchive.readArchive(input);
                return packageInfo;
            }
        }

        private static IllegalArgumentException error(Exception err) {
            return new IllegalArgumentException("Failed to parse python package", err);
        }

        private static PackageInfo readArchive(ArchiveInputStream input) throws IOException {
            ArchiveEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                if (!input.canReadEntryData(entry) || entry.isDirectory() || !entry.getName().contains("PKG-INFO") && !entry.getName().contains("METADATA")) continue;
                return new PackageInfo.FromMetadata(IOUtils.toString((InputStream)input, (Charset)StandardCharsets.US_ASCII));
            }
            throw new IllegalArgumentException("Package metadata file not found");
        }
    }
}

