/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi.meta;

import com.artipie.pypi.NormalizedProjectName;
import com.artipie.pypi.meta.PackageInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class ValidFilename {
    private static final Pattern ARCHIVE_PTRN = Pattern.compile("(?<name>.*)-(?<version>[0-9a-z.]+?)\\.([a-zA-Z.]+)");
    private static final Pattern WHEEL_PTRN = Pattern.compile("(?<name>.*?)-(?<version>[0-9a-z.]+)(-\\d+)?-((py\\d.?)+)-(.*)-(.*).whl");
    private final PackageInfo data;
    private final String filename;

    public ValidFilename(PackageInfo data, String filename) {
        this.data = data;
        this.filename = filename;
    }

    public boolean valid() {
        return Stream.of(WHEEL_PTRN.matcher(this.filename), ARCHIVE_PTRN.matcher(this.filename)).filter(Matcher::matches).findFirst().map(matcher -> {
            String name = new NormalizedProjectName.Simple(this.data.name()).value();
            return name.equals(new NormalizedProjectName.Simple(matcher.group("name")).value()) && this.data.version().equals(matcher.group("version"));
        }).orElse(false);
    }
}

