/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi.http;

import com.artipie.asto.Content;
import com.artipie.asto.Copy;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.FileStorage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.slice.KeyFromPath;
import com.artipie.pypi.NormalizedProjectName;
import com.artipie.pypi.http.Multipart;
import com.artipie.pypi.meta.Metadata;
import com.artipie.pypi.meta.PackageInfo;
import com.artipie.pypi.meta.ValidFilename;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.io.FileUtils;
import org.cactoos.list.ListOf;
import org.cactoos.scalar.Unchecked;
import org.reactivestreams.Publisher;

final class WheelSlice
implements Slice {
    private final Storage storage;

    WheelSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> iterable, Publisher<ByteBuffer> publisher) {
        Path path = (Path)new Unchecked(() -> Files.createTempDirectory("py-artifact-", new FileAttribute[0])).value();
        Path file = path.resolve(UUID.randomUUID().toString());
        FileStorage temp = new FileStorage(path);
        Key.From key = new Key.From(file.getFileName().toString());
        return new AsyncResponse(new Multipart(iterable, publisher).content().thenCompose(arg_0 -> this.lambda$response$4((Storage)temp, key, file, line, arg_0)).handle((ignored, throwable) -> {
            RsWithStatus res = new RsWithStatus(RsStatus.CREATED);
            if (throwable != null) {
                res = new RsWithStatus(RsStatus.BAD_REQUEST);
            }
            FileUtils.deleteQuietly((File)path.toFile());
            return res;
        }));
    }

    private /* synthetic */ CompletionStage lambda$response$4(Storage temp, Key.From key, Path file, String line, Multipart.Data data) {
        return ((CompletableFuture)temp.save((Key)key, (Content)new Content.From(data.bytes())).thenCompose(nothing -> new Copy(temp, (Collection)new ListOf((Object[])new Key[]{key})).copy(this.storage))).thenCompose(ignored -> {
            PackageInfo info = new Metadata.FromArchive(file, data.fileName()).read();
            if (new ValidFilename(info, data.fileName()).valid()) {
                return this.storage.move((Key)key, (Key)new Key.From((Key)new KeyFromPath(new RequestLineFrom(line).uri().toString()), new String[]{new NormalizedProjectName.Simple(info.name()).value(), data.fileName()}));
            }
            return this.storage.delete((Key)key).thenApply(nothing -> {
                throw new IllegalArgumentException("Uploaded filename does not correspond to file metadata");
            });
        });
    }
}

