/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.asto.streams.ContentAsStream;
import com.artipie.http.ArtipieHttpException;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.common.RsError;
import com.artipie.pypi.NormalizedProjectName;
import com.artipie.pypi.meta.Metadata;
import com.artipie.pypi.meta.PackageInfo;
import com.jcabi.xml.XMLDocument;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class SearchSlice
implements Slice {
    private final Storage storage;

    public SearchSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(new NameFromXml(body).get().thenCompose(name -> {
            Key.From key = new Key.From(new NormalizedProjectName.Simple((String)name).value());
            return this.storage.list((Key)key).thenCompose(list -> {
                CompletionStage<Object> res = new CompletableFuture<Content.From>();
                if (list.isEmpty()) {
                    res.complete(new Content.From(SearchSlice.empty()));
                } else {
                    Key latest = (Key)list.stream().map(Key::string).max(Comparator.naturalOrder()).map(Key.From::new).orElseThrow(IllegalStateException::new);
                    res = ((CompletableFuture)this.storage.value(latest).thenCompose(val -> new ContentAsStream((Publisher)val).process(input -> new Metadata.FromArchive((InputStream)input, latest.string()).read()))).thenApply(info -> new Content.From(SearchSlice.found(info)));
                }
                return res;
            });
        }).handle((content, throwable) -> {
            Object res = throwable == null ? new RsFull(RsStatus.OK, (Iterable)new Headers.From("content-type", "text/xml"), content) : new RsError(new ArtipieHttpException(RsStatus.INTERNAL_ERROR, throwable));
            return res;
        }));
    }

    static byte[] empty() {
        return String.join((CharSequence)"\n", "<methodResponse>", "<params>", "<param>", "<value><array><data>", "</data></array></value>", "</param>", "</params>", "</methodResponse>").getBytes(StandardCharsets.UTF_8);
    }

    static byte[] found(PackageInfo info) {
        return String.join((CharSequence)"\n", "<?xml version='1.0'?>", "<methodResponse>", "<params>", "<param>", "<value><array><data>", "<value><struct>", "<member>", "<name>name</name>", String.format("<value><string>%s</string></value>", info.name()), "</member>", "<member>", "<name>summary</name>", String.format("<value><string>%s</string></value>", info.summary()), "</member>", "<member>", "<name>version</name>", String.format("<value><string>%s</string></value>", info.version()), "</member>", "<member>", "<name>_pypi_ordering</name>", "<value><boolean>0</boolean></value>", "</member>", "</struct></value>", "</data></array></value>", "</param>", "</params>", "</methodResponse>").getBytes(StandardCharsets.UTF_8);
    }

    static final class NameFromXml {
        private final Publisher<ByteBuffer> body;

        NameFromXml(Publisher<ByteBuffer> body) {
            this.body = body;
        }

        CompletionStage<String> get() {
            String query = "//member/value/array/data/value/string/text()";
            return new PublisherAs(this.body).string(StandardCharsets.UTF_8).thenApply(xml -> new XMLDocument(xml).nodes("/*[local-name()='methodCall']/*[local-name()='params']/*[local-name()='param']/*[local-name()='value']/*[local-name()='struct']/*[local-name()='member']")).thenApply(nodes -> nodes.stream().filter(node -> ((String)node.xpath("//member/name/text()").get(0)).equals("name") && !node.xpath("//member/value/array/data/value/string/text()").isEmpty()).findFirst().map(node -> node.xpath("//member/value/array/data/value/string/text()")).map(node -> (String)node.get(0)).orElseThrow(() -> new IllegalArgumentException("Invalid xml, project name not found")));
        }
    }
}

