/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.pypi.http;

import com.artipie.ArtipieException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.streams.ContentAsStream;
import com.artipie.http.ArtipieHttpException;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentDisposition;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.multipart.RqMultipart;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.common.RsError;
import com.artipie.http.slice.KeyFromPath;
import com.artipie.pypi.NormalizedProjectName;
import com.artipie.pypi.meta.Metadata;
import com.artipie.pypi.meta.PackageInfo;
import com.artipie.pypi.meta.ValidFilename;
import com.jcabi.log.Logger;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Flowable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

final class WheelSlice
implements Slice {
    private final Storage storage;

    WheelSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> iterable, Publisher<ByteBuffer> publisher) {
        Key.From key = new Key.From(UUID.randomUUID().toString());
        return new AsyncResponse(this.filePart((Headers)new Headers.From(iterable), publisher, (Key)key).thenCompose(filename -> ((CompletableFuture)this.storage.value((Key)key).thenCompose(val -> new ContentAsStream((Publisher)val).process(input -> new Metadata.FromArchive((InputStream)input, (String)filename).read()))).thenCompose(info -> {
            CompletionStage res = new ValidFilename((PackageInfo)info, (String)filename).valid() ? this.storage.move((Key)key, (Key)new Key.From((Key)new KeyFromPath(new RequestLineFrom(line).uri().toString()), new String[]{new NormalizedProjectName.Simple(info.name()).value(), filename})).thenApply(ignored -> RsStatus.CREATED) : this.storage.delete((Key)key).thenApply(nothing -> RsStatus.BAD_REQUEST);
            return res.thenApply(RsWithStatus::new);
        })).handle((resp, throwable) -> {
            RsWithStatus res = resp;
            if (throwable != null) {
                res = new RsError(new ArtipieHttpException(RsStatus.BAD_REQUEST, throwable));
            }
            return res;
        }));
    }

    private CompletionStage<String> filePart(Headers headers, Publisher<ByteBuffer> body, Key temp) {
        return (CompletionStage)Flowable.fromPublisher((Publisher)new RqMultipart(headers, body).inspect((part, inspector) -> {
            if (new ContentDisposition(part.headers()).fieldName().equals("content")) {
                inspector.accept(part);
            } else {
                inspector.ignore(part);
            }
            CompletableFuture<Object> res = new CompletableFuture<Object>();
            res.complete(null);
            return res;
        })).doOnNext(part -> Logger.debug((Object)this, (String)"WS: multipart request body parsed, part %s found", (Object[])new Object[]{part})).flatMapSingle(part -> SingleInterop.fromFuture((CompletionStage)((CompletableFuture)this.storage.save(temp, (Content)new Content.From((Publisher)part)).thenRun(() -> Logger.debug((Object)this, (String)"WS: content saved to temp file `%s`", (Object[])new Object[]{temp.string()}))).thenApply(nothing -> new ContentDisposition(part.headers()).fileName()))).toList().map(items -> {
            if (items.isEmpty()) {
                throw new ArtipieException("content part was not found");
            }
            if (items.size() > 1) {
                throw new ArtipieException("multiple content parts were found");
            }
            return (String)items.get(0);
        }).to(SingleInterop.get());
    }
}

