/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.FileStorage;
import com.artipie.rpm.Digest;
import com.artipie.rpm.Rpm;
import com.artipie.rpm.StandardNamingPolicy;
import io.vertx.reactivex.core.Vertx;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class Cli {
    private final Rpm rpm;

    private Cli(Rpm rpm) {
        this.rpm = rpm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws ParseException {
        CommandLine cli = new DefaultParser().parse(new Options().addOption(Option.builder((String)"n").argName("np").longOpt("naming-policy").desc("(optional, default plain) configures NamingPolicy for Rpm: plain, sha256 or sha1").hasArg().build()).addOption(Option.builder((String)"d").argName("dgst").longOpt("digest").desc("(optional, default sha256) configures Digest instance for Rpm: sha256 or sha1").hasArg().build()), args);
        if (cli.getArgs().length != 1) {
            System.err.println("expected repository path");
            System.exit(1);
        }
        StandardNamingPolicy naming = StandardNamingPolicy.valueOf(cli.getOptionValue("np", "plain").toUpperCase(Locale.US));
        System.out.printf("RPM naming-policy=%s\n", naming);
        Digest digest = Digest.valueOf(cli.getOptionValue("dgst", "sha256").toUpperCase(Locale.US));
        System.out.printf("RPM digest=%s\n", new Object[]{digest});
        try (Vertx vertx = Vertx.vertx();){
            new Cli(new Rpm((Storage)new FileStorage(Paths.get((String)cli.getArgList().get(0), new String[0]), vertx.fileSystem()), naming, digest)).run();
        }
    }

    private void run() {
        this.rpm.batchUpdate(Key.ROOT).blockingAwait();
    }
}

