/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public enum Digest {
    SHA1("SHA-1", "sha"),
    SHA256("SHA-256", "sha256");

    private final String hashalg;
    private final String type;

    private Digest(String alg, String type) {
        this.hashalg = alg;
        this.type = type;
    }

    public MessageDigest messageDigest() {
        try {
            return MessageDigest.getInstance(this.hashalg);
        }
        catch (NoSuchAlgorithmException err) {
            throw new IllegalStateException(String.format("%s is unavailable on this environment", this.hashalg), err);
        }
    }

    public String type() {
        return this.type;
    }
}

