/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.rpm.Digest;
import com.artipie.rpm.pkg.Checksum;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;

public final class FileChecksum
implements Checksum {
    private static final int BUF_SIZE = 8192;
    private final Path file;
    private final Digest dgst;

    public FileChecksum(Path path, Digest dgst) {
        this.file = path;
        this.dgst = dgst;
    }

    @Override
    public Digest digest() {
        return this.dgst;
    }

    @Override
    public String hex() throws IOException {
        MessageDigest digest = this.dgst.messageDigest();
        try (FileChannel chan = FileChannel.open(this.file, StandardOpenOption.READ);){
            ByteBuffer buf = ByteBuffer.allocate(8192);
            while (chan.read(buf) > 0) {
                digest.update(buf);
            }
        }
        return DatatypeConverter.printHexBinary((byte[])digest.digest()).toLowerCase(Locale.US);
    }
}

