/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.rpm.Digest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.function.Supplier;
import org.bouncycastle.util.encoders.Hex;

public interface NamingPolicy {
    public String name(String var1, Path var2) throws IOException;

    public static final class HashPrefixed
    implements NamingPolicy {
        private final Supplier<MessageDigest> dgst;

        public HashPrefixed(Digest dgst) {
            this(dgst::messageDigest);
        }

        private HashPrefixed(Supplier<MessageDigest> dgst) {
            this.dgst = dgst;
        }

        @Override
        public String name(String source, Path content) throws IOException {
            MessageDigest digest = this.dgst.get();
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            try (FileChannel chan = FileChannel.open(content, StandardOpenOption.READ);){
                while (chan.read(buffer) > 0) {
                    digest.update(buffer);
                }
            }
            return String.format("%s-%s", Hex.toHexString((byte[])digest.digest()), source);
        }
    }
}

