/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.rpm.Digest;
import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.meta.XmlRepomd;
import com.artipie.rpm.pkg.MetadataFile;
import com.artipie.rpm.pkg.Package;
import com.artipie.rpm.pkg.PackageOutput;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

final class Repository
implements PackageOutput {
    private final XmlRepomd repomd;
    private final List<MetadataFile> metadata;
    private final Digest digest;

    Repository(XmlRepomd repomd, List<MetadataFile> files, Digest digest) {
        this.repomd = repomd;
        this.metadata = files;
        this.digest = digest;
    }

    public Repository update(Package pkg) throws IOException {
        pkg.save(this, this.digest);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Package.Meta meta) throws IOException {
        List<MetadataFile> list = this.metadata;
        synchronized (list) {
            new PackageOutput.Multiple(this.metadata).accept(meta);
        }
    }

    @Override
    public void close() throws IOException {
        new PackageOutput.Multiple(this.metadata).close();
        Logger.info((Object)this, (String)"repository closed");
    }

    public List<Path> save(NamingPolicy naming, Digest dgst) throws IOException {
        ArrayList<Path> outs = new ArrayList<Path>(this.metadata.size() + 1);
        for (MetadataFile item : this.metadata) {
            outs.add(item.save(naming, dgst));
            Logger.info((Object)this, (String)"metadata file saved: %s", (Object[])new Object[]{item});
        }
        this.repomd.close();
        Path file = this.repomd.file();
        outs.add(Files.move(file, file.getParent().resolve("repomd.xml"), new CopyOption[0]));
        Logger.info((Object)this, (String)"repomd.xml closed");
        return outs;
    }
}

