/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.FileStorage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.rpm.Digest;
import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.Repository;
import com.artipie.rpm.StandardNamingPolicy;
import com.artipie.rpm.meta.XmlRepomd;
import com.artipie.rpm.pkg.FilePackage;
import com.artipie.rpm.pkg.FilelistsOutput;
import com.artipie.rpm.pkg.MetadataFile;
import com.artipie.rpm.pkg.OthersOutput;
import com.artipie.rpm.pkg.PrimaryOutput;
import com.jcabi.log.Logger;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.schedulers.Schedulers;
import io.vertx.reactivex.core.Vertx;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public final class Rpm {
    private final Storage storage;
    private final NamingPolicy naming;
    private final Digest digest;

    public Rpm(Storage stg) {
        this(stg, StandardNamingPolicy.PLAIN, Digest.SHA256);
    }

    public Rpm(Storage stg, NamingPolicy naming, Digest dgst) {
        this.storage = stg;
        this.naming = naming;
        this.digest = dgst;
    }

    @Deprecated
    public Completable update(String key) {
        return this.update((Key)new Key.From(key));
    }

    @Deprecated
    public Completable update(Key key) {
        String[] parts = key.string().split("/");
        Object folder = parts.length == 1 ? Key.ROOT : new Key.From((String[])Arrays.stream(parts).limit(parts.length - 1).toArray(String[]::new));
        return this.batchUpdate((Key)folder);
    }

    @Deprecated
    public Completable batchUpdate(String prefix) {
        return this.batchUpdate((Key)new Key.From(prefix));
    }

    public Completable batchUpdate(Key prefix) {
        Path tmpdir;
        try {
            tmpdir = Files.createTempDirectory("repo-", new FileAttribute[0]);
        }
        catch (IOException err) {
            throw new IllegalStateException("Failed to create temp dir", err);
        }
        Vertx vertx = Vertx.vertx();
        FileStorage local = new FileStorage(tmpdir, vertx.fileSystem());
        return SingleInterop.fromFuture((CompletionStage)this.storage.list(prefix)).flatMapObservable(Observable::fromIterable).filter(key -> key.string().endsWith(".rpm")).flatMapSingle(arg_0 -> this.lambda$batchUpdate$3((Storage)local, tmpdir, arg_0)).observeOn(Schedulers.io()).reduceWith(() -> {
            XmlRepomd repomd = new XmlRepomd(Files.createTempFile("repomd-", ".xml", new FileAttribute[0]));
            repomd.begin(System.currentTimeMillis() / 1000L);
            return new Repository(repomd, Arrays.asList(new MetadataFile("primary", new PrimaryOutput(Files.createTempFile("primary-", ".xml", new FileAttribute[0])).start(), repomd), new MetadataFile("others", new OthersOutput(Files.createTempFile("others-", ".xml", new FileAttribute[0])).start(), repomd), new MetadataFile("filelists", new FilelistsOutput(Files.createTempFile("filelists-", ".xml", new FileAttribute[0])).start(), repomd)), this.digest);
        }, Repository::update).doOnSuccess(rep -> Logger.info((Object)this, (String)"repository updated")).doOnSuccess(Repository::close).doOnSuccess(rep -> Logger.info((Object)this, (String)"repository closed")).flatMapObservable(repo -> Observable.fromIterable(repo.save(this.naming, this.digest))).doOnNext(file -> Files.move(file, tmpdir.resolve(file.getFileName()), new CopyOption[0])).flatMapCompletable(arg_0 -> this.lambda$batchUpdate$10((Storage)local, arg_0)).doOnTerminate(() -> {
            Rpm.cleanup(tmpdir);
            vertx.close();
        });
    }

    private static void cleanup(Path dir) throws IOException {
        for (Path item : Files.list(dir).collect(Collectors.toList())) {
            Files.delete(item);
        }
    }

    private /* synthetic */ CompletableSource lambda$batchUpdate$10(Storage local, Path path) throws Exception {
        return new RxStorageWrapper(local).value((Key)new Key.From(path.getFileName().toString())).flatMapCompletable(content -> new RxStorageWrapper(this.storage).save((Key)new Key.From(new String[]{"repodata", path.getFileName().toString()}), content));
    }

    private /* synthetic */ SingleSource lambda$batchUpdate$3(Storage local, Path tmpdir, Key key) throws Exception {
        String file = Paths.get(key.string(), new String[0]).getFileName().toString();
        return new RxStorageWrapper(this.storage).value(key).flatMapCompletable(content -> new RxStorageWrapper(local).save((Key)new Key.From(file), content)).andThen((SingleSource)Single.just((Object)new FilePackage(tmpdir.resolve(file))));
    }
}

