/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

final class AlterAttributeEventReader
extends EventReaderDelegate {
    private final String tag;
    private final String attribute;
    private final String value;

    AlterAttributeEventReader(XMLEventReader delegate, String tag, String attribute, String value) {
        super(delegate);
        this.tag = tag;
        this.attribute = attribute;
        this.value = value;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent original = super.nextEvent();
        if (!original.isStartElement()) {
            return original;
        }
        StartElement element = original.asStartElement();
        if (!element.getName().getLocalPart().equals(this.tag)) {
            return original;
        }
        ArrayList<Attribute> newattrs = new ArrayList<Attribute>(0);
        XMLEventFactory events = XMLEventFactory.newFactory();
        boolean replaced = false;
        Iterator<Attribute> origattrs = element.getAttributes();
        while (origattrs.hasNext()) {
            Attribute attr = origattrs.next();
            if (attr.getName().getLocalPart().equals(this.attribute)) {
                newattrs.add(events.createAttribute(attr.getName(), this.value));
                replaced = true;
                continue;
            }
            newattrs.add(attr);
        }
        if (!replaced) {
            return original;
        }
        return events.createStartElement(element.getName().getPrefix(), element.getName().getNamespaceURI(), element.getName().getLocalPart(), newattrs.iterator(), element.getNamespaces(), element.getNamespaceContext());
    }
}

