/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.AlterAttributeEventReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;

final class XmlFile {
    private static final XMLOutputFactory FACTORY = XMLOutputFactory.newInstance();
    private final XMLStreamWriter xml;
    private final OutputStream stream;
    private final Path path;

    XmlFile(Path path) {
        this(path, XmlFile.outputStream(path));
    }

    private XmlFile(Path path, OutputStream out) {
        this(path, out, XmlFile.xmlStreamWriter(out));
    }

    private XmlFile(Path path, OutputStream out, XMLStreamWriter xml) {
        this.path = path;
        this.stream = out;
        this.xml = xml;
    }

    public XMLStreamWriter writer() {
        return this.xml;
    }

    public void alterTag(String tag, String attribute, String value) throws IOException {
        this.stream.close();
        Path trf = Files.createTempFile("", ".xml", new FileAttribute[0]);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("version", "1.0");
            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            transformer.setOutputProperty("standalone", "no");
            transformer.setOutputProperty("indent", "yes");
            try (InputStream input = Files.newInputStream(this.path, new OpenOption[0]);
                 OutputStream out = Files.newOutputStream(trf, new OpenOption[0]);){
                transformer.transform(new StAXSource(new AlterAttributeEventReader(XMLInputFactory.newFactory().createXMLEventReader(input), tag, attribute, value)), new StreamResult(out));
            }
            Files.move(trf, this.path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (XMLStreamException | TransformerException err) {
            throw new IOException("Failed to alter file", err);
        }
        finally {
            Files.deleteIfExists(trf);
        }
    }

    private static OutputStream outputStream(Path path) {
        try {
            return Files.newOutputStream(path, new OpenOption[0]);
        }
        catch (IOException err) {
            throw new UncheckedIOException("Failed to open file stream", err);
        }
    }

    private static XMLStreamWriter xmlStreamWriter(OutputStream out) {
        try {
            return FACTORY.createXMLStreamWriter(out, StandardCharsets.UTF_8.name());
        }
        catch (XMLStreamException err) {
            throw new IllegalStateException("Failed to create XML stream", err);
        }
    }
}

