/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.XmlFile;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class XmlFilelists
implements Closeable {
    private final XmlFile xml;
    private final AtomicInteger packages;

    public XmlFilelists(Path file) {
        this(new XmlFile(file));
    }

    public XmlFilelists(XmlFile xml) {
        this.xml = xml;
        this.packages = new AtomicInteger();
    }

    public XmlFilelists startPackages() throws XMLStreamException {
        this.xml.writer().writeStartDocument("UTF-8", "1.0");
        this.xml.writer().writeStartElement("filelists");
        this.xml.writer().writeDefaultNamespace("http://linux.duke.edu/metadata/filelists");
        this.xml.writer().writeAttribute("packages", "-1");
        return this;
    }

    public Package startPackage(String name, String arch, String checksum) throws XMLStreamException {
        this.xml.writer().writeStartElement("package");
        this.xml.writer().writeAttribute("pkgid", checksum);
        this.xml.writer().writeAttribute("name", name);
        this.xml.writer().writeAttribute("arch", arch);
        return new Package(this, this.xml.writer());
    }

    @Override
    public void close() throws IOException {
        try {
            this.xml.writer().writeEndElement();
            this.xml.writer().writeEndDocument();
            this.xml.writer().close();
            this.xml.alterTag("filelists", "packages", String.valueOf(this.packages.get()));
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to close", err);
        }
    }

    public static final class Package {
        private final XmlFilelists filelists;
        private final XMLStreamWriter xml;

        Package(XmlFilelists filelists, XMLStreamWriter xml) {
            this.filelists = filelists;
            this.xml = xml;
        }

        public Package version(int epoch, String ver, String rel) throws XMLStreamException {
            this.xml.writeEmptyElement("version");
            this.xml.writeAttribute("epoch", String.valueOf(epoch));
            this.xml.writeAttribute("ver", ver);
            this.xml.writeAttribute("rel", rel);
            return this;
        }

        public Package files(String[] files, String[] dirs, int[] did) throws XMLStreamException {
            Set dirset = Arrays.stream(dirs).collect(Collectors.toSet());
            for (int idx = 0; idx < files.length; ++idx) {
                String fle = files[idx];
                if (fle.isEmpty() || fle.charAt(0) == '.') continue;
                String path = String.format("%s%s", dirs[did[idx]], fle);
                this.xml.writeStartElement("file");
                if (dirset.contains(String.format("%s/", path))) {
                    this.xml.writeAttribute("type", "dir");
                }
                this.xml.writeCharacters(path);
                this.xml.writeEndElement();
            }
            return this;
        }

        public XmlFilelists close() throws XMLStreamException {
            this.xml.writeEndElement();
            this.filelists.packages.incrementAndGet();
            return this.filelists;
        }
    }
}

