/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.XmlFile;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class XmlOthers
implements Closeable {
    private final XmlFile xml;
    private final AtomicInteger packages;

    public XmlOthers(Path file) {
        this(new XmlFile(file));
    }

    private XmlOthers(XmlFile xml) {
        this.xml = xml;
        this.packages = new AtomicInteger();
    }

    public XmlOthers startPackages() throws XMLStreamException {
        this.xml.writer().writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
        this.xml.writer().writeStartElement("otherdata");
        this.xml.writer().writeDefaultNamespace("http://linux.duke.edu/metadata/other");
        this.xml.writer().writeAttribute("packages", "-1");
        return this;
    }

    public Package addPackage(String name, String arch, String checksum) throws XMLStreamException {
        this.xml.writer().writeStartElement("package");
        this.xml.writer().writeAttribute("pkgid", checksum);
        this.xml.writer().writeAttribute("name", name);
        this.xml.writer().writeAttribute("arch", arch);
        return new Package(this, this.xml.writer());
    }

    @Override
    public void close() throws IOException {
        try {
            this.xml.writer().writeEndElement();
            this.xml.writer().writeEndDocument();
            this.xml.writer().close();
            this.xml.alterTag("otherdata", "packages", String.valueOf(this.packages.get()));
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to close", err);
        }
    }

    public static final class Package {
        private final XmlOthers others;
        private final XMLStreamWriter xml;

        Package(XmlOthers others, XMLStreamWriter xml) {
            this.others = others;
            this.xml = xml;
        }

        public Package version(int eopch, String ver, String rel) throws XMLStreamException {
            this.xml.writeEmptyElement("version");
            this.xml.writeAttribute("epoch", String.valueOf(eopch));
            this.xml.writeAttribute("ver", ver);
            this.xml.writeAttribute("rel", rel);
            return this;
        }

        public Package changelog() throws XMLStreamException {
            this.xml.writeStartElement("changelog");
            this.xml.writeCharacters("NOT_IMPLEMENTED");
            this.xml.writeEndElement();
            return this;
        }

        public XmlOthers close() throws XMLStreamException {
            this.xml.writeEndElement();
            this.others.packages.incrementAndGet();
            return this.others;
        }
    }
}

