/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.Digest;
import com.artipie.rpm.FileChecksum;
import com.artipie.rpm.pkg.Checksum;
import com.artipie.rpm.pkg.Package;
import com.artipie.rpm.pkg.PackageOutput;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.redline_rpm.ReadableChannelWrapper;
import org.redline_rpm.Scanner;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Format;
import org.redline_rpm.header.Header;

public final class FilePackage
implements Package {
    private final Path file;

    public FilePackage(Path path) {
        this.file = path;
    }

    public Path path() {
        return this.file;
    }

    @Override
    public void save(PackageOutput out, Digest digest) throws IOException {
        out.accept(new Headers(this.header(), this.file, digest));
    }

    private Header header() throws IOException {
        try (FileChannel chan = FileChannel.open(this.file, StandardOpenOption.READ);){
            Format format = new Scanner(new PrintStream(Logger.stream((Level)Level.FINE, (Object)this))).run(new ReadableChannelWrapper((ReadableByteChannel)chan));
            Header header = format.getHeader();
            Logger.debug((Object)this, (String)"header: %s", (Object[])new Object[]{header.toString()});
            Header header2 = header;
            return header2;
        }
    }

    private static final class EntryHeader
    implements Package.MetaHeader {
        private final Optional<AbstractHeader.Entry<?>> entry;

        EntryHeader(AbstractHeader.Entry<?> entry) {
            this(Optional.ofNullable(entry));
        }

        EntryHeader(Optional<AbstractHeader.Entry<?>> entry) {
            this.entry = entry;
        }

        @Override
        public String asString(String def) {
            return this.entry.map(e -> ((String[])e.getValues())[0]).orElse(def);
        }

        @Override
        public int asInt(int def) {
            return this.entry.map(e -> ((int[])e.getValues())[0]).orElse(def);
        }

        @Override
        public List<String> asStrings() {
            return this.entry.map(e -> Arrays.asList((String[])e.getValues())).orElse(Collections.emptyList());
        }

        @Override
        public int[] asInts() {
            return this.entry.map(e -> (int[])e.getValues()).orElseGet(() -> new int[0]);
        }
    }

    private static final class Headers
    implements Package.Meta {
        private final Header hdr;
        private final Path file;
        private final Digest digest;

        Headers(Header hdr, Path file, Digest digest) {
            this.hdr = hdr;
            this.file = file;
            this.digest = digest;
        }

        @Override
        public Package.MetaHeader header(Header.HeaderTag tag) {
            return new EntryHeader(this.hdr.getEntry((AbstractHeader.Tag)tag));
        }

        @Override
        public Checksum checksum() {
            return new FileChecksum(this.file, this.digest);
        }

        @Override
        public long size() throws IOException {
            return Files.size(this.file);
        }

        @Override
        public String href() {
            return this.file.getFileName().toString();
        }

        @Override
        public int[] range() {
            return new int[]{this.hdr.getStartPos(), this.hdr.getEndPos()};
        }
    }
}

