/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.Digest;
import com.artipie.rpm.FileChecksum;
import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.meta.XmlRepomd;
import com.artipie.rpm.pkg.Package;
import com.artipie.rpm.pkg.PackageOutput;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLStreamException;

public final class MetadataFile
implements PackageOutput {
    private final String type;
    private final PackageOutput.FileOutput output;
    private final XmlRepomd repomd;

    public MetadataFile(String type, PackageOutput.FileOutput output, XmlRepomd repomd) {
        this.type = type;
        this.output = output;
        this.repomd = repomd;
    }

    @Override
    public void accept(Package.Meta meta) throws IOException {
        this.output.accept(meta);
    }

    @Override
    public void close() throws IOException {
        this.output.close();
        Logger.info((Object)this, (String)"output %s closed", (Object[])new Object[]{this.output});
    }

    public Path save(NamingPolicy naming, Digest digest) throws IOException {
        Path open = this.output.file();
        Path gzip = Files.createTempFile(this.type, ".gz", new FileAttribute[0]);
        MetadataFile.gzip(open, gzip);
        gzip = Files.move(gzip, gzip.getParent().resolve(String.format("%s.xml.gz", naming.name(this.type, gzip))), new CopyOption[0]);
        Logger.info((Object)this, (String)"gzipped %s to %s", (Object[])new Object[]{open, gzip});
        try (XmlRepomd.Data data = this.repomd.beginData(this.type);){
            data.gzipChecksum(new FileChecksum(gzip, digest));
            data.openChecksum(new FileChecksum(open, digest));
            data.location(String.format("repodata/%s", gzip.getFileName()));
            data.gzipSize(Files.size(gzip));
            data.openSize(Files.size(open));
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to update repomd.xml", err);
        }
        Files.delete(open);
        return gzip;
    }

    public String toString() {
        return String.format("MetadataFile: %s", this.type);
    }

    private static void gzip(Path input, Path output) throws IOException {
        try (InputStream fis = Files.newInputStream(input, new OpenOption[0]);
             OutputStream fos = Files.newOutputStream(output, new OpenOption[0]);
             GZIPOutputStream gzos = new GZIPOutputStream(fos);){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = fis.read(buffer)) >= 0) {
                gzos.write(buffer, 0, length);
            }
            gzos.finish();
        }
    }
}

