/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.pkg.Package;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;

public interface PackageOutput
extends Closeable {
    public void accept(Package.Meta var1) throws IOException;

    public static final class Multiple
    implements PackageOutput {
        private final Iterable<? extends PackageOutput> list;

        public Multiple(PackageOutput ... outs) {
            this(Arrays.asList(outs));
        }

        public Multiple(Iterable<? extends PackageOutput> outs) {
            this.list = outs;
        }

        @Override
        public void accept(Package.Meta meta) throws IOException {
            for (PackageOutput packageOutput : this.list) {
                packageOutput.accept(meta);
            }
        }

        @Override
        public void close() throws IOException {
            LinkedList<IOException> errors = new LinkedList<IOException>();
            for (PackageOutput packageOutput : this.list) {
                try {
                    packageOutput.close();
                }
                catch (IOException err) {
                    errors.add(err);
                }
            }
            if (!errors.isEmpty()) {
                IOException exc = new IOException("Couldn't close underlying outputs");
                errors.forEach(exc::addSuppressed);
                throw exc;
            }
        }
    }

    public static interface FileOutput
    extends PackageOutput {
        public Path file();

        public static final class Fake
        implements FileOutput {
            private final Path file;

            public Fake(Path file) {
                this.file = file;
            }

            public Fake start() throws IOException {
                Files.write(this.file, Arrays.asList("content"), new OpenOption[0]);
                return this;
            }

            @Override
            public void accept(Package.Meta meta) {
            }

            @Override
            public void close() {
            }

            @Override
            public Path file() {
                return this.file;
            }
        }
    }
}

