/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.files;

import com.jcabi.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public final class Gzip {
    private final Path file;

    public Gzip(Path file) {
        this.file = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unpackTar(Path dest) throws IOException {
        GzipCompressorInputStream input = new GzipCompressorInputStream(Files.newInputStream(this.file, new OpenOption[0]));
        try (TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)input);){
            TarArchiveEntry entry;
            while ((entry = (TarArchiveEntry)tar.getNextEntry()) != null) {
                OutputStream out;
                block23: {
                    File next = dest.resolve(entry.getName()).toFile();
                    if (entry.isDirectory()) {
                        next.mkdirs();
                        continue;
                    }
                    out = Files.newOutputStream(next.toPath(), new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)tar, (OutputStream)out);
                        if (out == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out == null) throw throwable3;
                            if (throwable == null) {
                                out.close();
                                throw throwable3;
                            }
                            try {
                                out.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        out.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                out.close();
            }
        }
        Logger.debug((Object)this, (String)"Unpacked tar.gz %s to %s", (Object[])new Object[]{this.file, dest});
    }

    public void unpack(Path dest) throws IOException {
        try (OutputStream out = Files.newOutputStream(dest, new OpenOption[0]);
             GZIPInputStream input = new GZIPInputStream(Files.newInputStream(this.file, new OpenOption[0]));){
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
        Logger.debug((Object)this, (String)"Unpacked gz %s to %s", (Object[])new Object[]{this.file, dest});
    }
}

