/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public interface XmlMaid {
    public long clean(List<String> var1) throws IOException;

    public static final class ByPkgidAttr
    implements XmlMaid {
        private static final String TAG = "package";
        private final Path file;

        public ByPkgidAttr(Path file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long clean(List<String> ids) throws IOException {
            long res;
            Path tmp = this.file.getParent().resolve(String.format("%s.part", this.file.getFileName().toString()));
            try (InputStream in = Files.newInputStream(this.file, new OpenOption[0]);
                 OutputStream out = Files.newOutputStream(tmp, new OpenOption[0]);){
                XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(in);
                XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(out);
                try {
                    res = ByPkgidAttr.process(ids, reader, writer);
                }
                finally {
                    writer.close();
                    reader.close();
                }
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
            Files.move(tmp, this.file, StandardCopyOption.REPLACE_EXISTING);
            return res;
        }

        private static long process(List<String> ids, XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
            boolean valid = true;
            long cnt = 0L;
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(TAG)) {
                    if (ids.contains(event.asStartElement().getAttributeByName(new QName("pkgid")).getValue())) {
                        valid = false;
                    } else {
                        valid = true;
                        ++cnt;
                    }
                }
                if (valid) {
                    writer.add(event);
                }
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(TAG)) continue;
                valid = true;
            }
            return cnt;
        }
    }
}

